
class Starfield
{
  int numStars = 100;
  int layers = 3;
  Star[] stars = new Star[numStars];
  int r;
  int g;
  int b;


  Starfield() {
  }


  void setup() {
    background(0);
    stroke(255);
  
    for(int i=0; i<numStars-1; i++) {
      stars[i] = new Star();
      stars[i].init(this);
    }
  }


  void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {  
    background(0);
    
    for(int i=0; i<numStars-2; i++) {
      
      fill(0);
      strokeWeight(8);
      r = 40; g = 69; b = 20;
        r += tan(i+partMillis*0.001)*64; g += sin(i+partMillis*0.01)*64; b += cos(i+partMillis*0.001)*64;
        stroke(r,g,b,255);
      ellipse((float)stars[i].x, (float)stars[i].y, 60*cos(partMillis*0.001), 60*sin(partMillis*0.001));
      stars[i].update(); 
    
    }
  }
}


class Star
{  
  public Starfield owner;
  public int x, y, c;
  
  public Star() {
    
  }
  
  void init(Starfield starfield) {
    this.owner = starfield;
    this.x = (int)random(0, width+10);
    this.y = (int)random(0, height-1);
    this.c = (int)random(0, this.owner.layers);
  }
  
  void update() {
    
    if(this.x <= -10 && partMillis < 1) {
      this.x = width-1;
      this.y = (int)random(0, height-1);
      this.c = (int)random(0, this.owner.layers);
    }
    
   this.x-= this.c+1;
   this.x -= this.c+1;
  }
}


